package gov.va.genisis2.converter;

import java.util.HashSet;
import java.util.Set;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

import gov.va.genisis2.dto.UserApproverDTO;
import gov.va.genisis2.model.User;
import gov.va.genisis2.model.UserApprover;

/**
 * This class is used to convert UserApproverDTO to UserApprover entity and
 * vice-versa.
 * 
 * @author Prasad Thummalapalli
 *
 */
@Component
public class UserApproverConverter implements Converter<UserApprover, UserApproverDTO> {

	@Autowired
	private UserConverter userConverter;

	@Override
	public UserApproverDTO convert(UserApprover userApprover) {
		UserApproverDTO userApproverDto = new UserApproverDTO();

		userApproverDto.setId(userApprover.getId());
		userApproverDto.setUserApproverId(userApprover.getUserApproverId());

		User approver = userApprover.getUsersByUserApproverId();
		if (null != approver) {
			userApproverDto.setUserApproversForUserId(userConverter.convert(approver));
		}

		userApproverDto.setUserId(userApprover.getUserId());

		return userApproverDto;
	}
	
	public Set<UserApproverDTO> convertUserApprovers(Set<UserApprover> userApprovers) {
		Set<UserApproverDTO> userApproversDtos = null;
		if (!userApprovers.isEmpty()) {
			userApproversDtos = new HashSet<>();
			for (UserApprover userApprover : userApprovers) {
				userApproversDtos.add(convertWithoutUser(userApprover));
			}
		}
		
		return userApproversDtos;
	}
	
	public UserApproverDTO convertWithoutUser(UserApprover userApprover) {
		UserApproverDTO userApproverDto = new UserApproverDTO();

		userApproverDto.setId(userApprover.getId());
		userApproverDto.setUserApproverId(userApprover.getUserApproverId());
		userApproverDto.setUserId(userApprover.getUserId());

		return userApproverDto;
	}
	

	/**
	 * @param userConverter the userConverter to set
	 */
	public void setUserConverter(UserConverter userConverter) {
		this.userConverter = userConverter;
	}
}